Function IsInstallerAdministrator()
   On Error Resume Next
   ' Create constants for access rights and registry hive 
   const KEY_QUERY_VALUE = &H0001 
   const KEY_SET_VALUE = &H0002 
   const KEY_CREATE = &H0032 
   const KEY_CREATE_SUB_KEY = &H0004 
   const KEY_DELETE = &H00010000 
   const HKEY_LOCAL_MACHINE = &H80000002 
   Dim shell
   Dim windir
   Dim filesys
   Dim f
   Dim Notice
   Notice = "The current user does not possess the administrative rights required to install " _
           & "Backup Professional on this server. The install process will terminate."
	   
   strComputer = "." 

   Set objReg=GetObject("winmgmts:"_ 
      & "{impersonationLevel=impersonate}!\\" &_ 
      strComputer & "\root\default:StdRegProv") 
   strKeyPath = "SYSTEM\CurrentControlSet" 

   if objReg is Nothing Then
		msgbox "Cannot create WMI interface for querying registry permissions",0
		Exit Function
	End If
	
   bHasAccessRight = True
   IsInstallerAdministrator=1
   

   ' Does the account under which the script runs have the 
   '    right to query the SYSTEM\CurrentControlSet key 
   objReg.CheckAccess HKEY_LOCAL_MACHINE, strKeyPath, DELETE, bHasAccessRight 

   If Err.Number <> 0 Then
		WScript.Echo  "Failed to properly check registry access HKEY_LOCAL_MACHINE: error " & Err.Number
   else 
		WScript.Echo  "User can access to registry HKEY_LOCAL_MACHINE"
   End If
   Err.Clear
 
   If bHasAccessRight = False Then 
      WScript.Echo "User does not have DELETE access to registry key HKEY_LOCAL_MACHINE"
      IsInstallerAdministrator=-1
   Else ' We will check again using another method
	  WScript.Echo "User has right to DELETE keys under HKEY_LOCAL_MACHINE"
      Set Shell = CreateObject("WScript.Shell")
      Set filesys = CreateObject("Scripting.FileSystemObject") 
      windir = Shell.ExpandEnvironmentStrings("%windir%") 
      Set f = filesys.OpenTextFile(windir & "\system32\drivers\etc\services",8,False,0)
      

      If Err.Number <> 0 Then
	    WScript.Echo "Failed to open file : " & windir & "\system32\drivers\etc\services : error " & Err.Number
        IsInstallerAdministrator=-1 
      Else
        IsInstallerAdministrator=1
		WScript.Echo "User can open services file : " & windir & "\system32\drivers\etc\services"
        f.Close
      End If
      Err.Clear
   End If 

   If IsInstallerAdministrator=-1 Then
        msgbox Notice,0
   End If

   Exit Function
End Function


Dim Inst
Inst = IsInstallerAdministrator 
WScript.Echo "Returned value: "  & Inst
WScript.Echo "-------------------------------------"


