DBCC traceon (3604);

create table #DBID(
FileID float,
LogicalName nvarchar(256),
BindingID nvarchar(50),
FileGroup float,
Size float,
MaxSize float,
MinSize float,
UserShrinkSize float,
Growth float,
BackupLSN float,
RedoStartLSN float,
FirstLSN float,
MaxLSN float,
FirstUpdateLSN float,
CreateLSN float,
SectorSize float,
ActualSectorSize float,
RecoveryForkGUID varchar(50),
RecoveryFOrkLSN float,
DifferentialBaseLSN float,
DifferentialBaseGUID varchar(50),
Status float,
RestoreStatus float,
ReadOnlyLsn float,
ReadWriteLsn float,
MaxLSNBranchId varchar(50),
RedoTargetPofloatLSN float,
RedoTargetPofloatGuid varchar(50),
RestoreDiffBaseLsn float,
RestoreDiffBaseGuid varchar(50),
RestorePathOriginLsn float,
RestorePathOriginGuid varchar(50),
OlderRestoredLsn float)



INSERT INTO #DBID
EXEC sp_MSForEachDB 'DBCC fileheader([?])'
 
update #DBID set BindingID = '|{' + BindingID + '}' 

select LogicalName,BindingID from #DBID 
where FileGroup = 1
and LogicalName not like 'Application_Registry_Service%'
and LogicalName not like 'Bdc_Service%'
and LogicalName not like 'Managed Metadata Service%'
and LogicalName not like 'master'
and LogicalName not like 'modeldev'
and LogicalName not like 'MSDBData'
and LogicalName not like 'PerformancePoint Service Application%'
and LogicalName not like 'Search_Service_Application%'
and LogicalName not like 'Secure_Store_Service%'
and LogicalName not like 'SharePoint_Config%'
and LogicalName not like 'StateService%'
and LogicalName not like 'tempdev'
and LogicalName not like 'User Profile Service Application%'
and LogicalName not like 'WebAnalyticsServiceApplication%'
and LogicalName not like 'WordAutomationServices%'
and LogicalName not like 'WSS_Logging'
and LogicalName not like 'WSS_Search_%'
order by LogicalName

drop table #DBID
dbcc traceoff(3604)