@echo off
SETLOCAL ENABLEDELAYEDEXPANSION

set INSTALL_DIR=C:\Program Files (x86)\Traverse
set JAVA_CMD=%INSTALL_DIR%\apps\jre\bin\java
set IMPORT_FILE=%INSTALL_DIR%\etc\deepWebTestScripts.xml

pushd "%INSTALL_DIR%" >NUL 2>&1
if not exist "etc\emerald.xml" (
  echo ERROR: unable to verify existence of installation directory ...
  echo ERROR: "%INSTALL_DIR%"
  exit /B 99
)

if not exist "%IMPORT_FILE%" (
  echo ERROR: unable to locate import file with transaction scripts
  echo ERROR: "%IMPORT_FILE%"
  popd
  exit /B 98
)

findstr /c:"accountSerialNumber=\"0\"" "%IMPORT_FILE%" > NUL 2>&1
if not ERRORLEVEL 1 (
  echo ERROR: at least one script has accountSerialNumber="0" ...
  echo ERROR: please update department serial numbers and try again
  popd
  exit /B 97
)

rem import the scripts
rem

"%JAVA_CMD%" -Xmx256m ^
  -XX:-UseSplitVerifier ^
  -Djava.ext.dirs="%INSTALL_DIR%\apps\jre\lib\ext;%INSTALL_DIR%\webapp\WEB-INF\lib" ^
  -Dlog4j.configuration="file:///%INSTALL_DIR%\etc\log4j.conf" ^
  -Dnetvigil.config="%INSTALL_DIR%\etc\emerald.properties" ^
  com.zyrion.traverse.utils.DeepWebTestScriptInserter ^
  "/%INSTALL_DIR%\etc\emerald.xml" "/%IMPORT_FILE%"

rem all done
rem

popd
