@echo off
SETLOCAL ENABLEDELAYEDEXPANSION

set INSTALL_DIR=C:\Program Files (x86)\Traverse
set JAVA_CMD=%INSTALL_DIR%\apps\jre\bin\java
set EXPORT_FILE=%INSTALL_DIR%\etc\deepWebTestScripts.xml

pushd "%INSTALL_DIR%" >NUL 2>&1
if not exist "etc\emerald.xml" (
  echo ERROR: unable to verify existence of installation directory ...
  echo ERROR: "%INSTALL_DIR%"
  exit /B 99
)

if exist "%EXPORT_FILE%" (
  echo ERROR: export file already exists ... please verify/remove
  echo ERROR: "%EXPORT_FILE%"
  popd
  exit /B 98
)

rem export the scripts
rem

"%JAVA_CMD%" -Xmx256m ^
  -XX:-UseSplitVerifier ^
  -Djava.ext.dirs="%INSTALL_DIR%\apps\jre\lib\ext;%INSTALL_DIR%\webapp\WEB-INF\lib" ^
  -Dlog4j.configuration="file:///%INSTALL_DIR%\etc\log4j.conf" ^
  -Dnetvigil.config="%INSTALL_DIR%\etc\emerald.properties" ^
  com.zyrion.traverse.utils.DeepWebTestScriptExtractor ^
  "/%INSTALL_DIR%\etc\emerald.xml" "/%EXPORT_FILE%"

rem all done
rem

popd
