#!/usr/bin/perl -w
## 
#
# COPYRIGHT:
#   Copyright 2011 Zyrion, Inc. All Rights Reserved. 
#   This software is the proprietary information of 
#   Zyrion, Inc. Use is subject to license terms.
#
# DESCRIPTION:
# Script to send an email from Traverse in an action profile
#
# Arguments are passed in the recipient field, so that the mail server as well 
# as the <from> address can be specified.
#
# Format : from|smtp server|recipient list in csv format
#
# Example :
# ./customEmail.pl --recipient="Traverse Server <traverse@zyrion.com>|127.0.0.1|test@zyrion.com,test2@zyrion.com"
#
# All other parameters are optional, though you should send through the ones
# referenced in the sameple email output (see the xml file for details).
#
# REQUIRES:
#   Net::SMTP (http://search.cpan.org/search?dist=libnet)
#   Getopt::Long (http://search.cpan.org/search?dist=Getopt-Long)
#
##

#use strict;
# Define the vars as specified in the developers guide first. These will
# be passed in from the XML as command line parameters, whether used or
# not, so that they are always available.
# - First, the generic variables available regardless of message type
use vars qw ( $department_name $timestamp $recipient $device_name 
              $device_serial_number $device_address $device_model 
			  $device_vendor $device_type $device_snmp_cid $device_snmp_version
			  $device_location $current_user_severity $current_shadow_severity
			  $current_sla_severity $time_in_state $action_item
			  $container_member_type $action_class $action_profile
			  $container_member_count_match $container_name $device_tag1
			  $device_tag2 $device_tag3 $device_tag4 $device_tag5
			  $affected_containers $device_tag1_caption $device_tag2_caption
			  $device_tag3_caption $device_tag4_caption $device_tag5_caption
			  $container_member_summary );
# - Now, the types specific to Polled Test Results
use vars qw ( $test_name $test_serial_number $test_user_warning_threshold
              $test_user_critical_threshold $test_shadow_warning_threshold
              $test_shadow_critical_threshold $test_sla_threshold $test_type
              $test_sub_type $test_units $result_value $event_reason );
# - Finally, the variable specific to Message Handler Events (traps, logs, etc)			  
use vars qw ( $message $message_source $ruleset_description $original_message
              $message_type );
			
# Define vars internal to the script			
use vars qw ( $DEBUG $email_from $email_server $email_to $OUTPUT);

use File::Basename;
use Cwd 'abs_path';
use lib (abs_path(dirname($0)) . "/../../lib/perl",
         abs_path(dirname($0)) . "/../../modules",
         "/usr/local/traverse/lib/perl",
         "/usr/local/traverse/modules",
         abs_path(dirname($0)) . "/perl-modules",
         abs_path(dirname($0)) . "/../../../../fcots/perl/");
use Getopt::Long;
use Net::SMTP;

use Zyrion::Debug;

$DEBUG=0;

# If we're debugging, open a logfile instead of STDOUT
if($DEBUG) {
  open(OUTPUT, ">>", "customEmail.log") ||
    die "Cannot open logfile : $!\n";

  # Dump the command line arguments
  my $numArgs = $#ARGV + 1;
  print OUTPUT "$numArgs command-line arguments passed:\n";
  foreach my $argnum (0 .. $#ARGV) {
    print OUTPUT "$ARGV[$argnum]\n";
  }

} else {
  open(OUTPUT, ">-") ||
    die "Cannot open STDOUT : $!\n";
}
  

# Gather the command line
GetOptions( 'debug|d'				=> \$DEBUG,
            'department_name=s'       		=> \$department_name,
            'timestamp=s'             		=> \$timestamp,
            'recipient=s'             		=> \$recipient,
            'device_name=s'           		=> \$device_name ,
            'device_serial_number=s'  		=> \$device_serial_number,
            'device_address=s'        		=> \$device_address,
            'device_model=s'          		=> \$device_model ,
            'device_vendor=s'         		=> \$device_vendor,
            'device_type=s'           		=> \$device_type,
            'device_snmp_cid=s'       		=> \$device_snmp_cid,
            'device_snmp_version=s'   		=> \$device_snmp_version,
            'device_location=s'       		=> \$device_location,
            'current_user_severity=s' 		=> \$current_user_severity,
            'current_shadow_severity=s' 	=> \$current_shadow_severity,
            'current_sla_severity=s'    	=> \$current_sla_severity,
            'time_in_state=s'           	=> \$time_in_state,
            'action_item=s'             	=> \$action_item,
            'action_class=s'            	=> \$action_class,
            'action_profile=s'          	=> \$action_profile,
            'device_tag1=s'             	=> \$device_tag1,
            'device_tag1_caption=s'     	=> \$device_tag1_caption,
            'device_tag2=s'             	=> \$device_tag2,
            'device_tag2_caption=s'     	=> \$device_tag2_caption,
            'device_tag3=s'             	=> \$device_tag3,
            'device_tag3_caption=s'     	=> \$device_tag3_caption,
            'device_tag4=s'             	=> \$device_tag4,
            'device_tag4_caption=s'     	=> \$device_tag4_caption,
            'device_tag5=s'             	=> \$device_tag5,
            'device_tag5_caption=s'     	=> \$device_tag5_caption,
            'container_member_count_match=s'   	=> \$container_member_count_match,
            'container_name=s'                 	=> \$container_name,
            'affected_containers=s'            	=> \$affected_containers,
            'container_member_summary=s'       	=> \$container_member_summary ,
            'container_member_type=s'          	=> \$container_member_type,
            'test_name=s'                      	=> \$test_name,
            'test_serial_number=s'             	=> \$test_serial_number,
            'test_user_warning_threshold=s'    	=> \$test_user_warning_threshold,
            'test_user_critical_threshold=s'   	=> \$test_user_critical_threshold,
            'test_shadow_warning_threshold=s'  	=> \$test_shadow_warning_threshold,
            'test_shadow_critical_threshold=s' 	=> \$test_shadow_critical_threshold,
            'test_sla_threshold=s'              => \$test_sla_threshold,
	    'test_type=s'  	                => \$$test_type,
            'test_sub_type=s'                  	=> \$test_sub_type,
            'test_units=s'                     	=> \$test_units,
            'result_value=s'                   	=> \$result_value,
            'event_reason=s'                   	=> \$event_reason,
            'message=s'                        	=> \$message,
            'message_source=s'                 	=> \$message_source,
            'ruleset_description=s' 		=> \$ruleset_description,
            'original_message=s' 		=> \$original_message,
            'message_type=s' 			=> \$message_type );

# The only required option is the recipient, everything else is optional.
if (! $recipient ) {
  die ("Recipient MUST be specified.");
  exit 1;
}
  
# Parse the host, and from address out of the recipient field
($email_from, $email_server, $email_to) = split(/\|/, $recipient);

# Send the email. Use the standard Traverse Format
print OUTPUT "\tSending email to ${email_to} from ${email_from} via ${email_server} ...\n";

if (! ($SMTP_OBJECT = Net::SMTP->new($email_server, 
									  Hello => "TraverseDGE",
									  Debug => $DEBUG))) {
  print OUTPUT "unable to communicate with smtp server : ${email_server} reason: $!";
  &exit_now(1);
}

$SMTP_OBJECT->mail($email_from);

# If multiple recipients are present, parse them out
if ($email_to =~ ",") {
  foreach my $list (split(/,/, $email_to)) {
    if (! $SMTP_OBJECT->to($list)) {
      print OUTPUT "smtp server rejected one or more recepients\n";
      &exit_now(1);
    }
  }
} else {  
  if (! $SMTP_OBJECT->to($email_to)) {
    print OUTPUT "smtp server rejected one or more recepients\n";
    &exit_now(1);
  }
}

$SMTP_OBJECT->data();
$SMTP_OBJECT->datasend("From: ${email_from}\n");
$SMTP_OBJECT->datasend("To: ${email_to}\n");
$SMTP_OBJECT->datasend("Subject: ${device_name}/${current_user_severity}: ${test_name}\n");
$SMTP_OBJECT->datasend("Reply-To: ${email_from}\n");
$SMTP_OBJECT->datasend("\n");
$SMTP_OBJECT->datasend(
  "\n" .
  "    Status Change Notification from Traverse:\n" .
  "\n".
  "    Department Name     : ${department_name}\n" .
  "    Device Name         : ${device_name}\n" .
  "    Device Address      : ${device_address}\n" .
  "    Test Name           : ${test_name}\n" .
  "    Current Severity    : ${current_user_severity}\n" .
  "    Polled Result       : ${result_value} ${test_units}\n" .
  "    Test Thresholds     : ${test_user_warning_threshold} (warn)/" .
  "                          ${test_user_critical_threshold} (crit)\n" .
  "    Test Time           : ${timestamp}\n" .
  "    Time In State       : ${time_in_state}\n" .
  "    Device Tag 1        : ${device_tag1}\n" .
  "    Device Tag 2        : ${device_tag2}\n" .
  "    Device Tag 3        : ${device_tag3}\n" .
  "    Device Tag 4        : ${device_tag4}\n" .
  "    Device Tag 5        : ${device_tag5}\n" .
  "    \n" .
  "     ---\n" .
  "    Triggered Via Action Item '${action_item}'\n"
);
$SMTP_OBJECT->dataend();
$SMTP_OBJECT->quit;

exit 0;
