#!/usr/bin/perl -w
#

##
#
# $Id: //depot/RELEASE/Traverse_5.0/src/plugin/samples/monitors/hostres/processCount.pl#1 $
#
# COPYRIGHT:
#  Copyright 2001-2005 Fidelia Technology, Inc. All Rights Reserved. This
#  software is the proprietary information of Fidelia Technology, Inc. Use
#  is subject to license terms.
#
# DESCRIPTION:
#  uses snmp to monitor how many processes of the specified name matches
#  and provides additional metrics regarding cpu and memory utilization
#
# OUTPUT: 
#  number of process found. if checking for existance of process via
#  @ prefix, 1 = running, 0 = not running
#
# REQUIRES:
#  Getopt::Long (http://search.cpan.org/search?dist=Getopt-Long)
#
##
  
use strict;
use vars qw($opt_host $opt_port $opt_cid $opt_ver $opt_process $opt_state
            $opt_resource $opt_regexp $DEBUG $SNMP_OBJ);

use File::Basename;
use Cwd 'abs_path';
use lib (abs_path(dirname($0)) . "/../../../lib/perl",
         abs_path(dirname($0)) . "/../../../perl/modules",
         abs_path(dirname($0)) . "/../../../../fcots/perl/");
use Getopt::Long;
use NetVigil::Debug;
use NetVigil::Discover::SNMP;


## variables -------------------------------------------------------------
##

$DEBUG                  = 0;
$ENV{"MIBS"}            = "";
$ENV{"MIBFILE"}         = "";
$ENV{"MIBFILE_v2"}      = "";
$opt_state              = 0;
$opt_regexp             = 0;
use constant TR_UNKNOWN => "-1\n";
use constant TR_FAILED  => "-2\n";
use constant OID_NAME   => ".1.3.6.1.2.1.25.4.2.1.2";
use constant OID_PATH   => ".1.3.6.1.2.1.25.4.2.1.4";
use constant OID_CPU    => ".1.3.6.1.2.1.25.5.1.1.1";
use constant OID_MEM    => ".1.3.6.1.2.1.25.5.1.1.2";
my $res_walk = OID_CPU;
my $proc_res;

## preliminary checks ----------------------------------------------------
##

GetOptions( 'host|h=s'    => \$opt_host,
            'version|v=s' => \$opt_ver,
            'comm|c=s'    => \$opt_cid,
            'port|p=i'    => \$opt_port,
            'process|s=s' => \$opt_process,
            'resource|r=s' => \$opt_resource,
            'debug|d'     => \$DEBUG);

if ((! $opt_host) || (! $opt_cid)) {
  &error("remote host address or snmp community string not specified");
  print TR_FAILED;
  exit 1;
}

$opt_process = "" unless ($opt_process);
$opt_resource = "" unless ($opt_resource);


if ($opt_process =~ /^\@(.*)/) {
  $opt_state = 1;
  $opt_process = $1;
} elsif ($opt_process =~ /^\%(.*)/) {
  $opt_regexp = 1;
  $opt_process = $1;
}


if (! $opt_process) {
  # at least one of CPU or memory must be set
  &error("no process name specified on command line");
  print TR_FAILED;
  exit 1;
}


## beginning of program ------------------------------------------------
##

$SNMP_OBJ = eval { new NetVigil::Discover::SNMP(
                    host      =>  $opt_host,
                    version   =>  $opt_ver, 
                    port      =>  $opt_port, 
                    community =>  $opt_cid,
                    separator =>  '|', 
                    path      =>  abs_path(dirname($0)) . 
                                  "/../../../bin",
                    DEBUG     =>  $DEBUG) 
                 };

if (ref($SNMP_OBJ) ne "NetVigil::Discover::SNMP") {
  &error("failed to initialize snmp object");
  print TR_UNKNOWN;
  exit 1;
} elsif ($SNMP_OBJ->error_message) {
  &error($SNMP_OBJ->error_message);
  print TR_UNKNOWN;
  exit 1;
}

my %PROCESS_DATA = ();
my $proc_count = 0;
my $proc_res = 0;
my @walk_output = $SNMP_OBJ->walk(OID_NAME);
if (!(scalar(@walk_output))) {

  print ("0");
}

foreach my $proc_data (@walk_output) {
  chop($proc_data);
  my ($proc_pid, $proc_name) = split(/\s+/, $proc_data, 2);
  my @OID_OCTETS = split(/\./, $proc_pid);
  $proc_pid = pop(@OID_OCTETS) || "";
  next unless ($proc_pid || $proc_name);
  $proc_name =~ s/^\"|\"$//g;
  &debug("pid: $proc_pid; name: $proc_name");
  $PROCESS_DATA{$proc_pid}{name} = $proc_name;
  $PROCESS_DATA{$proc_pid}{path} = "";
  $PROCESS_DATA{$proc_pid}{res} = "";
}

@walk_output = $SNMP_OBJ->walk(OID_PATH);
foreach my $proc_data (@walk_output) {
  chop($proc_data);
  my ($proc_pid, $proc_path) = split(/\s+/, $proc_data, 2);
  my @OID_OCTETS = split(/\./, $proc_pid);
  $proc_pid = pop(@OID_OCTETS) || "";
  next unless ($proc_pid || $proc_path);
  next unless (defined($PROCESS_DATA{$proc_pid}{name}));
  $proc_path =~ s/\\\\/\//g;
  $proc_path =~ s/^\"|\"$//g;
  $proc_path =~ s/\/$//g;
  if ($proc_path) {
    if ($proc_path ne $PROCESS_DATA{$proc_pid}{name}) {
      if ($proc_path =~ /\/$PROCESS_DATA{$proc_pid}{name}$/) {
        $proc_path = dirname($proc_path);
      }
    } else {
      $proc_path = "";
    }
    &debug("pid: $proc_pid; path: \'$proc_path\'");
    $PROCESS_DATA{$proc_pid}{path} = $proc_path;
  }
}

if ($opt_resource) {
  if ($opt_resource eq "mem") {
     $res_walk = OID_MEM;
  }
  @walk_output = $SNMP_OBJ->walk($res_walk);
  foreach my $proc_data (@walk_output) {
    chop($proc_data);
    my ($proc_pid, $proc_res) = split(/\s+/, $proc_data, 2);
    my @OID_OCTETS = split(/\./, $proc_pid);
  $proc_pid = pop(@OID_OCTETS) || "";
  next unless ($proc_pid || $proc_res);
  next unless (defined($PROCESS_DATA{$proc_pid}{name}));
  $PROCESS_DATA{$proc_pid}{res} = $proc_res;
  }
}
  
my $proc_res = 0;  
foreach my $proc_pid (keys %PROCESS_DATA) {
  
  my $proc_name = $PROCESS_DATA{$proc_pid}{path};
  $proc_name .= ($proc_name ? "/" : "");
  $proc_name .= $PROCESS_DATA{$proc_pid}{name};
  my $proc_resource .= $PROCESS_DATA{$proc_pid}{res};
  &debug("current process: $proc_name; $opt_resource: $proc_resource;");
  if ($opt_regexp) {
    &debug("checking $proc_name =~ /$opt_process/i");
    if ($proc_name =~ /$opt_process/i) {
      $proc_count++;
      if ($PROCESS_DATA{$proc_pid}{res} > $proc_res) {
        $proc_res = $PROCESS_DATA{$proc_pid}{res};
      }
    }
  } else {  
    &debug("checking $proc_name =~ /^(.*\/)?$opt_process\$/i");
    if ($proc_name =~ /^(.*\/)?$opt_process$/i) { 
      $proc_count++; 
    
      if ($PROCESS_DATA{$proc_pid}{res} > $proc_res) {
        $proc_res = $PROCESS_DATA{$proc_pid}{res};
      }
    }
  }
  &debug("match count = $proc_count");
  &debug("resource: $opt_resource = $proc_res");
}

if ($opt_resource) {
  print $proc_res;
} elsif ($opt_state) {
    print ($proc_count ? "1" : "0");
} else {
  print ($proc_count ? $proc_count : "0");
}
print "\n";
