#!/usr/bin/perl
# Check cert expiration, print # of days until cert expires.
# Errors printed on return, return of -2 is error, -1 is unknown.

use Getopt::Long;
use Time::Local;
use POSIX qw(strftime);


my $GREP    = "/bin/grep";
my $RM      = "/bin/rm";

my %months = ( "Jan",1,"Feb",2,"Mar",3,"Apr",4,
               "May",5,"Jun",6,"Jul",7,"Aug",8,
               "Sep",9,"Oct",10,"Nov",11,"Dec",12);


my $ERR_TMP = "/tmp/.err_tmp.$$";
my $OUT_TMP = "/tmp/.out_tmp.$$";
my $IS_WINDOWS = ($^O =~ /win32/i) ? 1:0;
my $DEBUG = 0;

my $HOST = "";
my $PORT = "";

my $OPENSSL = "openssl";
if($IS_WINDOWS == 1) {
  $OPENSSL = "C:\\OpenSSL-Win32\\bin\\openssl";
}
my $help = 0;

my $stat = GetOptions(
    "host|h=s" => \$HOST,
    "port|p=s" => \$PORT,
    "server|s=s" => \$SERVER,
    "debug|d" => \$DEBUG,
    "help|?" => \$help,
);

if($SERVER eq "") { $SERVER = $HOST; }

#if(($host eq "" && $port eq "") || $help>0) {
#  die "ERROR: Usage: -h|--host <hostname> -p|--port <port>\n-2\n";
#}

my $tstart = time();
print "Checking $HOST:$PORT ($SERVER)\n" if($DEBUG);
my $cmd="echo QUIT|$OPENSSL s_client -connect $HOST:$PORT -servername $SERVER -prexit -no_ign_eof 2>&1 |$OPENSSL x509 -dates -noout 2>&1";
my $dates = `$cmd`;
if($? == 1) { die "ERROR: Certificate Error or no Certificate!\n-2"; }
print $dates if($DEBUG);

if($dates =~ /unable to load certificate/) {
 print "ERROR: Error retrieving certificate(s)\n";
 print "ERROR: $dates\n";
 print "-1\n";
 exit;
}

$dates =~ /notBefore=(.*)/;
my ($smon,$smday,$stime,$syear,$stz) = split(' ',$1);
my ($shour,$smin,$ssec) = split(/:/, $stime);
my $nbefore = timelocal($ssec,$smin,$shour,$smday,($months{$smon})-1,$syear);
if($nbefore >= $tstart) {
  print "ERROR: Certificate NOTBEFORE date is in the future!\n";
  print "-1\n";
  exit;
}

$dates =~ /notAfter=(.*)/;
my $endDate = $1;
my ($emon,$emday,$etime,$eyear,$etz) = split(' ',$endDate);
my ($ehour,$emin,$esec) = split(/:/, $etime);
my $tend = timelocal($esec,$emin,$ehour,$emday,($months{$emon})-1,$eyear);
my $days_to_expire = (($tend - $tstart) / 86400);
if($days_to_expire < 0) {
  print "DEBUG: Certificate expired at $ehour:$emin:$esec on $emon $emday, $eyear\n";
  printf "DEBUG: Certificate expired %d days ago.\n", abs($days_to_expire);
  $days_to_expire = 0;
} else {
  print "DEBUG: Certificate expires at $ehour:$emin:$esec on $emon $emday, $eyear\n";
}

printf "%d\n", $days_to_expire;
exit;
